/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field19C
extends Field
implements Serializable,
AmountContainer {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "19C";
    public static final String F_19C = "19C";
    @Deprecated
    public static final String PARSER_PATTERN = "[S]N";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SN";
    @Deprecated
    public static final String TYPES_PATTERN = "SI";
    public static final Integer SIGN = 1;
    public static final Integer ADJUSTMENT_FACTOR = 2;
    @Deprecated
    public static final Integer AMOUNT = 2;

    public Field19C() {
        super(2);
    }

    public Field19C(String value) {
        super(value);
    }

    public Field19C(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"19C")) {
            throw new IllegalArgumentException("cannot create field 19C from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field19C newInstance(Field19C source) {
        Field19C cp = new Field19C();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("19C", value);
    }

    public static Tag emptyTag() {
        return new Tag("19C", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
        this.setComponent2(SwiftParseUtils.getNumericSuffix(value));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 19C");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            BigDecimal n = this.getComponent2AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String typesPattern() {
        return TYPES_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "[<N>]<AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 1;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Sign");
        result.add("Adjustment Factor");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "sign");
        result.put(2, "adjustmentFactor");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getSign() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public BigDecimal getComponent2AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(2));
    }

    @Deprecated
    public Number getComponent2AsNumber() {
        return this.getComponent2AsBigDecimal();
    }

    public String getAdjustmentFactor() {
        return this.getComponent2();
    }

    @Deprecated
    public String getAmount() {
        return this.getAdjustmentFactor();
    }

    public BigDecimal getAdjustmentFactorAsBigDecimal() {
        return this.getComponent2AsBigDecimal();
    }

    @Deprecated
    public Number getAdjustmentFactorAsNumber() {
        return this.getComponent2AsNumber();
    }

    @Deprecated
    public BigDecimal getAmountAsBigDecimal() {
        return this.getAdjustmentFactorAsBigDecimal();
    }

    @Deprecated
    public Number getAmountAsNumber() {
        return this.getAdjustmentFactorAsNumber();
    }

    public Field19C setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field19C setSign(String component1) {
        return this.setComponent1(component1);
    }

    public Field19C setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field19C setComponent2(BigDecimal component2) {
        this.setComponent(2, SwiftFormatUtils.getBigDecimal(component2));
        return this;
    }

    public Field19C setComponent2(Number component2) {
        if (component2 instanceof BigDecimal) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal((BigDecimal)component2));
        } else if (component2 instanceof BigInteger) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component2)));
        } else if (component2 instanceof Long || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component2.longValue())));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component2.doubleValue())));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field19C setAdjustmentFactor(String component2) {
        return this.setComponent2(component2);
    }

    public Field19C setAdjustmentFactor(BigDecimal component2) {
        return this.setComponent2(component2);
    }

    public Field19C setAdjustmentFactor(Number component2) {
        return this.setComponent2(component2);
    }

    @Deprecated
    public Field19C setAmount(String component2) {
        return this.setAdjustmentFactor(component2);
    }

    @Deprecated
    public Field19C setAmount(BigDecimal component2) {
        return this.setAdjustmentFactor(component2);
    }

    @Deprecated
    public Field19C setAmount(Number component2) {
        return this.setAdjustmentFactor(component2);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public String getName() {
        return "19C";
    }

    public static Field19C get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("19C");
        if (t == null) {
            return null;
        }
        return new Field19C(t);
    }

    public static Field19C get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field19C.get(msg.getBlock4());
    }

    public static List<Field19C> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field19C.getAll(msg.getBlock4());
    }

    public static List<Field19C> getAll(SwiftTagListBlock block) {
        ArrayList<Field19C> result = new ArrayList<Field19C>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("19C");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field19C(f));
            }
        }
        return result;
    }

    public static Field19C fromJson(String json) {
        Field19C field = new Field19C();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("sign") != null) {
            field.setComponent1(jsonObject.get("sign").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent2(jsonObject.get("amount").getAsString());
        }
        if (jsonObject.get("adjustmentFactor") != null) {
            field.setComponent2(jsonObject.get("adjustmentFactor").getAsString());
        }
        return field;
    }
}

