/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io;

import com.prowidesoftware.swift.io.AbstractWriter;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Objects;

public class RJEWriter
extends AbstractWriter {
    private static final String MESSAGE_TO_WRITE_CONDITION = "message to write cannot be null";
    private static final String WRITER_MESSAGE = "writer has not been initialized";
    private int count = 0;
    private char splitChar = (char)36;

    public RJEWriter(Writer writer) {
        super(writer);
    }

    public RJEWriter(File file) throws FileNotFoundException {
        super(file);
    }

    public RJEWriter(String filename) throws FileNotFoundException {
        super(filename);
    }

    public RJEWriter(File _file, Charset _charset) throws FileNotFoundException {
        super(_file, _charset);
    }

    public RJEWriter(OutputStream stream) {
        super(stream);
    }

    public RJEWriter(OutputStream _stream, Charset _charset) {
        super(_stream, _charset);
    }

    public static void write(AbstractMT msg, Writer writer) throws IOException {
        Objects.requireNonNull(msg, MESSAGE_TO_WRITE_CONDITION);
        RJEWriter.write(msg.message(), writer);
    }

    public static void write(String msg, Writer writer) throws IOException {
        Objects.requireNonNull(writer, WRITER_MESSAGE);
        Objects.requireNonNull(msg, MESSAGE_TO_WRITE_CONDITION);
        writer.write(msg);
        writer.write("\r\n");
        writer.write(36);
        writer.write("\r\n");
    }

    public void write(String msg) throws IOException {
        this._write(msg, this.writer);
    }

    public void write(AbstractMT msg) throws IOException {
        this._write(msg.message(), this.writer);
    }

    private void _write(String msg, Writer writer) throws IOException {
        Objects.requireNonNull(writer, WRITER_MESSAGE);
        Objects.requireNonNull(msg, MESSAGE_TO_WRITE_CONDITION);
        if (this.count > 0) {
            writer.write("\r\n");
            writer.write(this.splitChar);
            writer.write("\r\n");
        }
        writer.write(msg);
        ++this.count;
    }

    public void setSplitChar(char c) {
        this.splitChar = c;
    }
}

