/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class Lib {
    private Lib() {
    }

    public static String readFile(String filename) throws IOException {
        return Lib.readFile(new File(filename));
    }

    public static String readFile(File file) throws IOException {
        return Lib.readFile(file, null);
    }

    public static String readFile(File file, String encoding) throws IOException {
        if (!(file != null && file.exists() && file.canRead() && file.isFile())) {
            return null;
        }
        String charset = encoding != null ? encoding : "UTF-8";
        StringBuilder sb = new StringBuilder((int)file.length());
        try (FileInputStream fileStream = new FileInputStream(file);
             BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fileStream, charset));){
            int c;
            while ((c = in.read()) != -1) {
                sb.append((char)c);
            }
        }
        return sb.toString();
    }

    public static String readResource(String resource) throws IOException {
        return Lib.readResource(resource, null);
    }

    public static String readResource(String resource, String encoding) throws IOException {
        return Lib.readResource(resource, encoding, null);
    }

    public static String readResource(String resource, String encoding, Class<?> clazz) throws IOException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        if (is == null && clazz != null) {
            is = clazz.getClassLoader().getResourceAsStream(resource);
        }
        if (is == null) {
            return "";
        }
        return Lib.readStream(is, encoding);
    }

    public static String readStream(InputStream stream) throws IOException {
        return Lib.readStream(stream, (Charset)null);
    }

    public static String readStream(InputStream stream, String enconding) throws IOException {
        if (stream == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        String enc = enconding != null ? enconding : "UTF-8";
        try (InputStreamReader in = new InputStreamReader(stream, enc);){
            int c;
            while ((c = ((Reader)in).read()) != -1) {
                out.append((char)c);
            }
        }
        return out.toString();
    }

    public static String readStream(InputStream stream, Charset charset) throws IOException {
        if (stream == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        try (InputStreamReader in = new InputStreamReader(stream, charset != null ? charset : StandardCharsets.UTF_8);){
            int c;
            while ((c = ((Reader)in).read()) != -1) {
                out.append((char)c);
            }
        }
        return out.toString();
    }

    public static String readReader(Reader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        try {
            int c;
            while ((c = reader.read()) != -1) {
                out.append((char)c);
            }
        }
        finally {
            reader.close();
        }
        return out.toString();
    }
}

